/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.core;

import java.io.Serializable;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.core.Instance;

public class BinaryInstance
implements Serializable {
    private static final long serialVersionUID = 977143245642898382L;
    private Instance mInstance;
    private Cutpoints sCutpoints;

    public BinaryInstance(Instance instance, Cutpoints cutpoints) {
        this.mInstance = instance;
        this.sCutpoints = cutpoints;
    }

    public Boolean getAttributeAt(int index) {
        if (this.sCutpoints.valueAt(index) <= this.mInstance.value(this.sCutpoints.attAt(index))) {
            return true;
        }
        return false;
    }

    public boolean compareAtt(int index, BinaryInstance bInst) {
        if (this.isMissingAttribute(index) || bInst.isMissingAttribute(index)) {
            return false;
        }
        return this.getAttributeAt(index).booleanValue() == bInst.getAttributeAt(index).booleanValue();
    }

    public boolean isMissingAttribute(int index) {
        return this.mInstance.isMissing(this.sCutpoints.attAt(index));
    }

    public boolean instanceClass() {
        return this.mInstance.classValue() == 0.0;
    }

    public int numAttributes() {
        return this.sCutpoints.numCutpoints();
    }

    public int numOfOccurrences() {
        return 1;
    }

    public void increaseNumberOfOccurrences() {
    }

    public String toString() {
        String s = this.instanceClass() ? "+" : "-";
        int i = 0;
        while (i < this.numAttributes()) {
            s = !this.isMissingAttribute(i) ? String.valueOf(s) + (this.getAttributeAt(i) != false ? "1" : "0") : String.valueOf(s) + "?";
            ++i;
        }
        return s;
    }
}

